rm(list=ls())
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\Datenstze\\Bruchsal")
# Alternative: Einstellen des Arbeitsverzeichnisses ber Datei - Verzeichnis wechseln 
filename <- file.choose()
dat <- read.table(filename,header=FALSE)
#
# ndern der Spaltenbezeichnungen
names(dat) <- c("X","Y","P","EC","pH","NitCo","Nr") 
#
# Selektion der vollstndigen Datenstze
cc <- complete.cases(dat)
dat1 <- dat[cc,]
#
# Anzeigen und Schreiben der ersten fnf Zeilen des Datensatzes
print(dat1[1:5,])
write.table(dat1, file = "Bru_RF_T1.txt", sep = "\t", row.names = F)
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y,asp=1,main="Lage der Messpunkte",xlab = "X (m)", ylab = "Y (m)", pch=13,cex=1.5,col="blue",lwd=2)
pause()
#--------------------------------------------------------------------------
#   Elementarstatistik
#--------------------------------------------------------------------------
so <- summary(dat1)
cat("--- summary dat1 ---\n")
print(so)
pause()
plot(dat1[,c(3:6)])
co <- cor(dat1[,c(3:6)])
print(co)
#
#par(ask=T) # damit die Graphiken nicht durchrauschen
par(mfrow=c(1,4))
boxplot(dat1[,3],lwd = 2,col = "blue",notch = T, main = "Precipitation")
boxplot(dat1[,4],lwd = 2,col = "red",notch = T, main = "Electr. Conduct.")
boxplot(dat1[,5],lwd = 2,col = "green",notch = T, main = "pH")
boxplot(dat1[,6],lwd = 2,col = "grey",notch = T, main = "Nitrate Conc.")
pause()
#
# --- Skriptende ---
